const systemTags = {
  state: {
    sVisitedViews: [],
    sCachedViews: []
  },
  mutations: {
    S_ADD_VISITED_VIEWS: (state, view) => {
      if (state.sVisitedViews.some(v => v.path === view.path)) return
      if (view.path === '/') return
      state.sVisitedViews.push(
        Object.assign({}, view, {
          title: view.meta.title || 'no-name'
        })
      )
      if (!view.meta.noCache) {
        state.sCachedViews.push(view.name)
      }
    },
    S_DEL_VISITED_VIEWS: (state, view) => {
      for (const [i, v] of state.sVisitedViews.entries()) {
        if (v.path === view.path) {
          state.sVisitedViews.splice(i, 1)
          break
        }
      }
      for (const i of state.sCachedViews) {
        if (i === view.name) {
          const index = state.sCachedViews.indexOf(i)
          state.sCachedViews.splice(index, 1)
          break
        }
      }
    },
    S_DEL_OTHERS_VIEWS: (state, view) => {
      for (const [i, v] of state.sVisitedViews.entries()) {
        if (v.path === view.path) {
          state.sVisitedViews = state.sVisitedViews.slice(i, i + 1)
          break
        }
      }
      for (const i of state.sCachedViews) {
        if (i === view.name) {
          const index = state.sCachedViews.indexOf(i)
          state.sCachedViews = state.sCachedViews.slice(index, index + 1)
          break
        }
      }
    },
    S_DEL_ALL_VIEWS: state => {
      state.sVisitedViews = []
      state.sCachedViews = []
    }
  },
  actions: {
    sAddVisitedViews({ commit }, view) {
      commit('S_ADD_VISITED_VIEWS', view)
    },
    sDelVisitedViews({ commit, state }, view) {
      return new Promise(resolve => {
        commit('S_DEL_VISITED_VIEWS', view)
        resolve([...state.sVisitedViews])
      })
    },
    sDelOthersViews({ commit, state }, view) {
      return new Promise(resolve => {
        commit('S_DEL_OTHERS_VIEWS', view)
        resolve([...state.sVisitedViews])
      })
    },
    sDelAllViews({ commit, state }) {
      return new Promise(resolve => {
        commit('S_DEL_ALL_VIEWS')
        resolve([...state.sVisitedViews])
      })
    }
  }
}
export default systemTags
