const orderTags = {
  state: {
    oVisitedViews: [],
    oCachedViews: []
  },
  mutations: {
    O_ADD_VISITED_VIEWS: (state, view) => {
      if (state.oVisitedViews.some(v => v.path === view.path)) return
      if (view.path === '/') return
      state.oVisitedViews.push(
        Object.assign({}, view, {
          title: view.meta.title || 'no-name'
        })
      )
      if (!view.meta.noCache) {
        state.oCachedViews.push(view.name)
      }
    },
    O_DEL_VISITED_VIEWS: (state, view) => {
      for (const [i, v] of state.oVisitedViews.entries()) {
        if (v.path === view.path) {
          state.oVisitedViews.splice(i, 1)
          break
        }
      }
      for (const i of state.oCachedViews) {
        if (i === view.name) {
          const index = state.oCachedViews.indexOf(i)
          state.oCachedViews.splice(index, 1)
          break
        }
      }
    },
    O_DEL_OTHERS_VIEWS: (state, view) => {
      for (const [i, v] of state.oVisitedViews.entries()) {
        if (v.path === view.path) {
          state.oVisitedViews = state.oVisitedViews.slice(i, i + 1)
          break
        }
      }
      for (const i of state.oCachedViews) {
        if (i === view.name) {
          const index = state.oCachedViews.indexOf(i)
          state.oCachedViews = state.oCachedViews.slice(index, index + 1)
          break
        }
      }
    },
    O_DEL_ALL_VIEWS: state => {
      state.oVisitedViews = []
      state.oCachedViews = []
    }
  },
  actions: {
    oAddVisitedViews({ commit }, view) {
      commit('O_ADD_VISITED_VIEWS', view)
    },
    oDelVisitedViews({ commit, state }, view) {
      return new Promise(resolve => {
        commit('O_DEL_VISITED_VIEWS', view)
        resolve([...state.oVisitedViews])
      })
    },
    oDelOthersViews({ commit, state }, view) {
      return new Promise(resolve => {
        commit('O_DEL_OTHERS_VIEWS', view)
        resolve([...state.oVisitedViews])
      })
    },
    oDelAllViews({ commit, state }) {
      return new Promise(resolve => {
        commit('O_DEL_ALL_VIEWS')
        resolve([...state.oVisitedViews])
      })
    }
  }
}
export default orderTags
