const goodsTags = {
  state: {
    gVisitedViews: [],
    gCachedViews: []
  },
  mutations: {
    G_ADD_VISITED_VIEWS: (state, view) => {
      if (state.gVisitedViews.some(v => v.path === view.path)) return
      if (view.path === '/') return
      state.gVisitedViews.push(
        Object.assign({}, view, {
          title: view.meta.title || 'no-name'
        })
      )
      if (!view.meta.noCache) {
        state.gCachedViews.push(view.name)
      }
    },
    G_DEL_VISITED_VIEWS: (state, view) => {
      for (const [i, v] of state.gVisitedViews.entries()) {
        if (v.path === view.path) {
          state.gVisitedViews.splice(i, 1)
          break
        }
      }
      for (const i of state.gCachedViews) {
        if (i === view.name) {
          const index = state.gCachedViews.indexOf(i)
          state.gCachedViews.splice(index, 1)
          break
        }
      }
    },
    G_DEL_OTHERS_VIEWS: (state, view) => {
      for (const [i, v] of state.gVisitedViews.entries()) {
        if (v.path === view.path) {
          state.gVisitedViews = state.gVisitedViews.slice(i, i + 1)
          break
        }
      }
      for (const i of state.gCachedViews) {
        if (i === view.name) {
          const index = state.gCachedViews.indexOf(i)
          state.gCachedViews = state.gCachedViews.slice(index, index + 1)
          break
        }
      }
    },
    G_DEL_ALL_VIEWS: state => {
      state.gVisitedViews = []
      state.gCachedViews = []
    }
  },
  actions: {
    gAddVisitedViews({ commit }, view) {
      commit('G_ADD_VISITED_VIEWS', view)
    },
    gDelVisitedViews({ commit, state }, view) {
      return new Promise(resolve => {
        commit('G_DEL_VISITED_VIEWS', view)
        resolve([...state.gVisitedViews])
      })
    },
    gDelOthersViews({ commit, state }, view) {
      return new Promise(resolve => {
        commit('G_DEL_OTHERS_VIEWS', view)
        resolve([...state.gVisitedViews])
      })
    },
    gDelAllViews({ commit, state }) {
      return new Promise(resolve => {
        commit('G_DEL_ALL_VIEWS')
        resolve([...state.gVisitedViews])
      })
    }
  }
}

export default goodsTags
