const financalTags = {
  state: {
    fVisitedViews: [],
    fCachedViews: []
  },
  mutations: {
    F_ADD_VISITED_VIEWS: (state, view) => {
      if (state.fVisitedViews.some(v => v.path === view.path)) return
      if (view.path === '/') return
      state.fVisitedViews.push(
        Object.assign({}, view, {
          title: view.meta.title || 'no-name'
        })
      )
      if (!view.meta.noCache) {
        state.fCachedViews.push(view.name)
      }
    },
    F_DEL_VISITED_VIEWS: (state, view) => {
      for (const [i, v] of state.fVisitedViews.entries()) {
        if (v.path === view.path) {
          state.fVisitedViews.splice(i, 1)
          break
        }
      }
      for (const i of state.fCachedViews) {
        if (i === view.name) {
          const index = state.fCachedViews.indexOf(i)
          state.fCachedViews.splice(index, 1)
          break
        }
      }
    },
    F_DEL_OTHERS_VIEWS: (state, view) => {
      for (const [i, v] of state.fVisitedViews.entries()) {
        if (v.path === view.path) {
          state.fVisitedViews = state.fVisitedViews.slice(i, i + 1)
          break
        }
      }
      for (const i of state.fCachedViews) {
        if (i === view.name) {
          const index = state.fCachedViews.indexOf(i)
          state.fCachedViews = state.fCachedViews.slice(index, index + 1)
          break
        }
      }
    },
    F_DEL_ALL_VIEWS: state => {
      state.fVisitedViews = []
      state.fCachedViews = []
    }
  },
  actions: {
    fAddVisitedViews({ commit }, view) {
      commit('F_ADD_VISITED_VIEWS', view)
    },
    fDelVisitedViews({ commit, state }, view) {
      return new Promise(resolve => {
        commit('F_DEL_VISITED_VIEWS', view)
        resolve([...state.fVisitedViews])
      })
    },
    fDelOthersViews({ commit, state }, view) {
      return new Promise(resolve => {
        commit('F_DEL_OTHERS_VIEWS', view)
        resolve([...state.fVisitedViews])
      })
    },
    fDelAllViews({ commit, state }) {
      return new Promise(resolve => {
        commit('F_DEL_ALL_VIEWS')
        resolve([...state.fVisitedViews])
      })
    }
  }
}
export default financalTags
