// id值一旦前台生成，发送给后台，前后台都不会改变这个值，只有前台清除了cookie，会再重新生成，token的刷新还有过期都是用jwt做验证的
const jwt = require('jsonwebtoken')
import Log from '../assets/js/log.js'
import requestApi from '../assets/js/requestApi.js'
const fs = require('fs')
var path = require('path')
let logpath = requestApi.server_getConfig('logpath')
var filep = path.join(logpath, 'session.log')
console.log(filep)
const stream = fs.createWriteStream(filep, { flags: 'a', defaultEncoding: 'utf8' })
const log = new Log('debug', stream)

module.exports = (opts = {}) => {
  let env = process.env.WD_ENV
  // log.info('session env === ' + env)
  let redis = requestApi.server_getConfig('redis')
  const { key = "y-token", store = new RedisStore(redis.host, redis.port, redis.pwd) } = opts

  return async (ctx, next) => {
    let token = ctx.cookies.get(key, opts);
    // log.info(ctx.req.url + '  ======token value ==== ' + token)
    let id = undefined
    let isExpire = false //已过期
    let isRefresh = false //需要刷新
    let isCreate = false
    let sec = 'dd^$token2018'
    //如果token存在
    if(token) {
      try{
        let content = jwt.verify(token, sec)
        if(content) {
          id = content.key
          if (ctx.url.indexOf('/xhr') !== -1) {
            log.info(ctx.url + '-----------get token key ' + id)
          }
          if(content.exp) {
            if(content.exp < Date.now()/1000) {
              isExpire = true
            }
            else if(content.exp > (content.exp + Date.now()/1000)/2) {
              isRefresh = true
            }
          }
        }
      }
      catch(err) {
        ctx.throw(401, 'invalid token')
        // log.info('invalid token key ' + id)
      }
    }
    
    if(!id) {
      if (ctx.url.indexOf('/xhr') !== -1) {
        log.info(ctx.url + '-----------need create token key ')
      }
      isCreate = true
      ctx.session = {}
    }
    else {
      ctx.session = await store.get(id, ctx)
//    console.log('judg type == ' + typeof ctx.session + 'ctx.session === ' + ctx.session + 'keys.lenght === ' + Object.keys(ctx.session).length)
      if((typeof ctx.session !== "object" && typeof ctx.session !== 'string') || ctx.session == null || Object.keys(ctx.session).length === 0 ) {
        ctx.session = {}
        if (ctx.url.indexOf('/xhr') !== -1) {
          log.info(ctx.url + '-----------token key1 ' + id)
        }
        store.destroy(id, ctx)
        isCreate = true
        // log.info('session has no value ')
      }else{
       // log.info(ctx.url + '-------session has value-----' + JSON.stringify(ctx.session))
        ctx.req.session = ctx.session // for nuxtServerInit
        ctx.req.token = token
        // store.state.auth = ctx.session
      }
    }

    if(Object.keys(ctx.session).length && ctx.session.nextToken) { //其它请求已经刷新过token了
    //  console.log('session has been freshed')
      token = ctx.session.nextToken
      ctx.cookies.set(key, ctx.session.nextToken, opts)
    }
    else {
      if(isCreate || isRefresh || isExpire) {
        log.info('session need create ' + isCreate + ',need fresh ' + isRefresh  + ', isExpire  ' + isExpire)
        let expTime = Date.now()/1000 + 7 * 24 * 3600
        ctx.session = {userId: 0, userName: '', type: 0}
        const sid = await store.set(ctx.session, Object.assign({}, opts, {sid:undefined, exp: expTime}), ctx)
        console.log('sid:' + sid)
        if(isRefresh) {
          ctx.session.nextToken = sid
          await store.set(ctx.session, Object.assign({}, opts, {sid:id, maxAge:2800000}), ctx) //原来的key设置为8小时后过期
          ctx.session.nextToken = undefined
        }

        token = jwt.sign({'key':sid, expiresIn: '8h', notBefore:-3600000}, sec)
       // log.info('new token  value' + token)
        ctx.cookies.set(key, token, opts)
      }
    }

    ctx.req.session = ctx.session // for nuxtServerInit
    ctx.req.token = token
    await next()
    ctx.req.token = null
    ctx.req.session = null
  }
}
