const Redis = require('ioredis')
const { randomBytes } = require('crypto')

class RedisStore {
  constructor(host, port, pass) {
    if(pass ==undefined || pass == '') {
      this.redis = new Redis({
        host: host,
        port: port
      })
    }
    else {
      this.redis = new Redis( {
        host: host,
        port: port,
        password: pass
      })
    }
  }

  getID(length) {
    return randomBytes(length).toString('hex');
  }

  async get(sid, ctx) {
    let data = await this.redis.get(`YSESSION:${sid}`)
    return JSON.parse(data)
  }

  async set(session, { sid = this.getID(24), maxAge= 1000000} = {} , ctx) {
    try {
      await this.redis.set(`YSESSION:${sid}`, JSON.stringify(session), 'EX', maxAge/1000)
    }catch(e) {

    }
    return sid;
  }

  async destroy(sid, ctx) {
    return await this.redis.del(`YSESSION:${sid}`)
  }
} 

module.exports = RedisStore