import Koa from 'koa'
import Router from 'koa-router'
import { Nuxt, Builder } from 'nuxt'
import Log from '../assets/js/log.js'
import qs from 'qs'
import requestApi from '../assets/js/requestApi.js'
// const send = require('koa-send')
const fs = require('fs')
var path = require('path')
let logpath = requestApi.server_getConfig('logpath')
var filep = path.join(logpath, 'wlog.log')
console.log(filep)
const stream = fs.createWriteStream(filep, { flags: 'a', defaultEncoding: 'utf8' })
const log = new Log('debug', stream)
const session = require('../session')
const RedisStore = require('../session/RedisStore')

async function start () {
  const app = new Koa()
  const router = new Router()
 // 要区分是线上环境还是开发环境，端口号还有redis都不同
  let config = {}
  let env = process.env.WD_ENV
  let redis = requestApi.server_getConfig('redis')
  console.log('get redis info ===' + redis.host + '=====' + redis.pwd + '=====' + redis.port)
  let port = process.env.PORT || 3000
  log.info('use ' + env + '   configuration')
  app.use(session({
      store: new RedisStore(redis.host, redis.port, redis.pwd)
  }))
 if (env === 'production') {
    config = require('../nuxt.config-prod.js')
    port = process.env.PORT || 8080
    config.dev = false
 } else if (env === 'test') {
    config = require('../nuxt.config-test.js')
    port = process.env.PORT || 8080
    config.dev = false
 } else {
  console.log('dev--------')
    config = require('../nuxt.config-dev.js')
    console.log('config dev --- ====' + config)
    config.dev = true
 }
  console.log('33333')
  // Instantiate nuxt.js
  const nuxt = new Nuxt(config)

  // 生产模式不需要 build
  if (config.dev) {
    console.log('4444')
    const builder = new Builder(nuxt)
    await builder.build()
    console.log('55555')
  }
/* 
router.get('/excel/download', async function(ctx) {
    var fileName = ctx.originalUrl
    var ls = fileName.split('?name=')
    console.dir(ls)
    var file = ls[1]
    var currFile = path.join('static/file/',file)
    console.log('file name === ' + currFile)
    // const path = `upload/${name}'
    ctx.attachment(currFile)
    await send(ctx, currFile)
})
*/
console.log('2222')
  app
  .use(router.routes())
  .use(router.allowedMethods())
  app.use(async (ctx, next) => {
    await next()
    ctx.status = 200 // koa defaults to 404 when it sees that status is unset
    return new Promise((resolve, reject) => {
      ctx.res.on('close', resolve)
      ctx.res.on('finish', resolve)
      log.debug('ctx.request == ' + ctx.req.url + ',       ctx.statuscode === ' + ctx.res.statusCode)
      nuxt.render(ctx.req, ctx.res, promise => {
        // nuxt.render passes a rejected promise into callback on error.
        promise.then(resolve).catch(reject)
      })
    })
  })
  console.log('111111')
  app.listen(port)
  console.log('Server listening on '+ ':' + port) // eslint-disable-line no-console
}

start()
