var path = require('path')
module.exports = {
  /*
  ** Headers of the page
  */
  head: {
    title: '洋800',
    meta: [
      { charset: 'utf-8' },
      { name: 'viewport', content: 'width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0' },
      { hid: 'description', name: 'description', content: '洋800是一家专注于跨境电商保税仓的服务商，职责是做您的"正品保税仓"，您只需负责挑选进口商品和分享全球好货，我拥有强大的商品、物流团队，让您安心做海外代购专家。洋800拥有各种高品质的进口商品和品牌方，多年来为各大平台提供优质的跨境保税服务，让洋800可以更从容的为您服务，为您带来全新的跨境电商体验，让您瞬间成为国际买手达人。洋800，专业的国际买手服务商。' }
    ],
    link: [
      { rel: 'icon', type: 'image/x-icon', href: '/favicon.ico' }
    ],
    script:[{ innerHTML: 'var cnzz_protocol = (("https:" == document.location.protocol) ? " https://" : " http://");document.write(unescape("%3Cspan id=\'cnzz_stat_icon_1273890888\'%3E%3C/span%3E%3Cscript src=\'" + cnzz_protocol + "s19.cnzz.com/z_stat.php%3Fid%3D1273890888%26show%3Dpic\' type=\'text/javascript\'%3E%3C/script%3E"))', type: 'text/javascript', charset: 'utf-8'},
    {innerHTML: 'document.write(unescape("%3Cscript src=\'https://hm.baidu.com/hm.js?15740c19dd8c24913adccb501a340e74\' type=\'text/javascript\'%3E%3C/script%3E"))', type: 'text/javascript', charset: 'utf-8'},
    {innerHTML: 'document.write(unescape("%3Cscript src=\'https://qiyukf.com/script/d0783d6d8af7d0426096a6c18ffc223e.js\' type=\'text/javascript\'%3E%3C/script%3E"))', type: 'text/javascript', charset: 'utf-8'}],
    __dangerouslyDisableSanitizers: ['script']
  },
  /*
  ** Global CSS
  */
  css: [
    '~assets/css/main.css',
    'element-ui/lib/theme-chalk/index.css'
    // 'vant/lib/vant-css/index.css'
    ],
  /*
  ** Customize the progress-bar color
  */
  loading: { 
    color: '#3B8070',
    duration: 10
  },
  transition: {
    name: 'page',
    mode: 'out-in',
    duration: 10
  },
  modules:[
    '@nuxtjs/axios'
  ],

  axios: {
    proxy: true, // Can be also an object with default options
    withCredentials: true
  },
  plugins: [
    // {src: '@/plugins/element-ui'},
    {src: '@/plugins/filters'},
    {src: '@/plugins/axios'}
    
  ],
  /*
   ** Build configuration
   */
  build: {
    /*
     ** Run ESLINT on save
     */
    extend (config, ctx) {
      if (ctx.isClient) {
        config.node = {
          setImmediate: false,
          dgram: 'empty',
          fs: 'empty',
          net: 'empty',
          tls: 'empty',
          cluster: 'empty',
          child_process: 'empty'
        }
        config.module.rules.push({
          enforce: 'pre',
          test: /\.(js|vue)$/,
          loader: 'eslint-loader',
          exclude: [/(node_modules)/, /(log.js)/, /(vue-page.js)/]
        })
      }
    }
  },
  router: {
    middleware: 'authenticated',
    middleware: 'notAuthenticated',
    middleware: 'stats'
  } 
}
