export default {
  readLocalCookie(name) {
    // console.log('processs == ' + JSON.stringify(process))
    // console.log('read cookie' + document.cookie)
    let cookieValue = ''
    let search = name + '='
    if (document.cookie.length > 0) {
      let offset = document.cookie.indexOf(search)
      if (offset !== -1) {
        offset += search.length
        let end = document.cookie.indexOf(';', offset)
        if (end === -1) {
          end = document.cookie.length
        }
        cookieValue = unescape(document.cookie.substring(offset, end))
      }
    }
    return cookieValue
  },
  setLocalCookie(name, value) {
    this.clearLocalCookie(name)
    let ckr = name + '=' + escape(value) + ';'
    ckr += 'path=/;'
    // console.log('set cookie' + ckr)
    document.cookie = ckr
  },
  clearLocalCookie(name) {
    let exp = new Date()
    exp.setTime(exp.getTime() - 1)
    let cval = this.readLocalCookie(name)
    if (cval !== undefined && cval !== null && cval !== '') {
      document.cookie = name + '=' + cval + ';expires=' + exp.toGMTString()
    }
  }
}
