import requestApi from './requestApi.js'
export default {
  wxPayInfo: async function (orderSn, cobj, from) {
    console.log('支付的订单编号=== ' + orderSn)
    let va = navigator.userAgent.toLowerCase()
    let inWeixin = false
    if (va.indexOf('micromessenger') > 0) {
      inWeixin = true
    }
    let param = {
      orderSn: orderSn,
      inWeixin: inWeixin
    }
    let obj = await requestApi.getWxPayInfo(cobj, param)
    console.log('getWxPayInfo  === ' + JSON.stringify(obj))
    if (obj.code === 'success') {
      let res = obj.data
      if (res.testFlag) {
      } else if (res.h5Flag) {
        var url = res.data
        let host = requestApi.client_getConfig('host')
        window.location.href = url + '&redirect_url=' + encodeURI(host + '/order/order?tab=1')
      } else {
        this.wxPay(JSON.parse(res.data), cobj, from, orderSn)
      }
    }
  },
    // 支付
  wxPay(res, cobj, from, orderSn) {
    let param = {
      appId: res.appId,
      timeStamp: res.timeStamp,
      nonceStr: res.nonceStr,
      package: res.package,
      signType: res.signType,
      paySign: res.paySign
    }
    console.log()
    if (typeof WeixinJSBridge !== 'undefined') {
      this.onBridgeReady(param, cobj, from, orderSn)
    }
  },
  onBridgeReady(param, cobj, from, orderSn) {
    let that = cobj
    WeixinJSBridge.invoke('getBrandWCPayRequest', param, // eslint-disable-line no-undef
      function (res) {
        // alert('errormsg == ' + JSON.stringify(res))
        let success = 1
        if (res.err_msg === 'get_brand_wcpay_request:ok') {
          success = 0
        }
        if (from === 1) {
          that.$router.push({
            path: '/order/pay_success',
            query: {
              success: success,
              orderNo: orderSn
            }
          })
        }
      })
  }
}
