var qs = require('qs')

export default {
  wRequest: async function (url, obj, params) {
    if (params !== undefined) {
      let param = qs.stringify(params)
      let result = await obj.$axios.$post(url, param)
      // console.log('test api3 == ' + JSON.stringify(result) + 'result type ==== ' + typeof result)
      return result
    }
    let result = await obj.$axios.$post(url)
    // console.log('test api1 == ' + JSON.stringify(result) + 'result type ==== ' + typeof result)
    return result
  },
  getRequest: async function (url, obj, params) {
    if (params !== undefined) {
      let param = qs.stringify(params)
      let result = await obj.$axios.$get(url, param)
      // console.log('test api1 == ' + JSON.stringify(result.data))
      return result
    }
    let result = await obj.$axios.$get(url)
    // console.log('test api2 == ' + JSON.stringify(result.data))
    return result
  },
  postByJson: async function (url, obj, params) {
    // json格式的网络请求，需要指定content-type，并且参数不能用qs转化成key=value的形式，直接以json对象传递就可以
    let result = await obj.$axios({
      headers: {
        'Content-Type': 'application/json'
      },
      method: 'post',
      url: url,
      data: params
    })
    return result // 返回数据的异常
  },
  // 开始定时器
  startTimer(obj) {
    let that = obj
    const TIME_COUNT = 60
    if (!obj.timer) {
      obj.count = TIME_COUNT
      obj.timer = setInterval(() => {
        if (that.count > 0 && that.count <= TIME_COUNT) {
          that.count--
          that.btnText = '已发送(' + that.count + ')'
        } else {
          clearInterval(that.timer)
          that.timer = null
          that.btnText = '重新发送'
          that.btnDisable = false
        }
      }, 1000)
    }
  },
  // 验证手机号码
  identyTelNumber(tel) {
    if (tel === undefined || tel === null || tel === '') {
      return false
    }
    var reg = 11 && /^((13|14|15|17|18)[0-9]{1}\d{8})$/
    if (!reg.test(tel)) {
      return false
    }
    return true
  },
  // 验证中文字符
  hasChinese(checkStr) {
    var reg = /[\u4E00-\u9FA5]/g
    if (reg.test(checkStr)) {
      return false
    }
    return true
  },
  identyEmail(email) {
    if (email === undefined || email === '') {
      alert('请输入邮箱')
      return false
    }
    var reg = /^([a-zA-Z0-9]+[_|\_|\.]?)*[a-zA-Z0-9]+@([a-zA-Z0-9]+[_|\_|\.]?)*[a-zA-Z0-9]+\.[a-zA-Z]{2,3}$/ // eslint-disable-line no-useless-escape
    if (!reg.test(email)) {
      alert('请输入正确的邮箱')
      return false
    }
    return true
  },
  // 获取角色权限列表
  roleAuthList(obj) { return this.wRequest('/xhr/getMenus', obj) },
  server_getConfig(key) {
    if (process.env.WD_ENV === 'production') {
      var configp = require('../config/config-prod.json')
      return configp[key]
    } else if (process.env.WD_ENV === 'test') {
      var configt = require('../config/config-test.json')
      return configt[key]
    }
    var configdev = require('../config/config-dev.json')
    return configdev[key]
  },
  client_getConfig(key) {
    if (window.location.href.indexOf('m.yang800.com') !== -1) {
      var configp = require('../config/config-prod.json')
      return configp[key]
    } else if (window.location.href.indexOf('mtest.yang800.cn') !== -1) {
      var configt = require('../config/config-test.json')
      return configt[key]
    }
    var configdev = require('../config/config-dev.json')
    return configdev[key]
  }
}
